# Generated by Django 3.1.4 on 2020-12-01 07:12

import django.contrib.postgres.indexes
import django.db.models.deletion
import mptt.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("files", "0001_initial"),
        ("users", "0001_initial"),
    ]

    operations = [
        migrations.AddField(
            model_name="tag",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="subtitle",
            name="language",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="files.language"),
        ),
        migrations.AddField(
            model_name="subtitle",
            name="media",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="subtitles",
                to="files.media",
            ),
        ),
        migrations.AddField(
            model_name="subtitle",
            name="user",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="rating",
            name="media",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="ratings",
                to="files.media",
            ),
        ),
        migrations.AddField(
            model_name="rating",
            name="rating_category",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="files.ratingcategory"),
        ),
        migrations.AddField(
            model_name="rating",
            name="user",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="playlistmedia",
            name="media",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="files.media"),
        ),
        migrations.AddField(
            model_name="playlistmedia",
            name="playlist",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="files.playlist"),
        ),
        migrations.AddField(
            model_name="playlist",
            name="media",
            field=models.ManyToManyField(blank=True, through="files.PlaylistMedia", to="files.Media"),
        ),
        migrations.AddField(
            model_name="playlist",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="playlists",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="category",
            field=models.ManyToManyField(
                blank=True,
                help_text="Media can be part of one or more categories",
                to="files.Category",
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="channel",
            field=models.ForeignKey(
                blank=True,
                help_text="Media can exist in one or no Channels",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="users.channel",
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="license",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="files.license",
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="rating_category",
            field=models.ManyToManyField(
                blank=True,
                help_text="Rating category, if media Rating is allowed",
                to="files.RatingCategory",
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="tags",
            field=models.ManyToManyField(
                blank=True,
                help_text="select one or more out of the existing tags",
                to="files.Tag",
            ),
        ),
        migrations.AddField(
            model_name="media",
            name="user",
            field=models.ForeignKey(
                help_text="user that uploads the media",
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="encoding",
            name="media",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="encodings",
                to="files.media",
            ),
        ),
        migrations.AddField(
            model_name="encoding",
            name="profile",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="files.encodeprofile"),
        ),
        migrations.AddField(
            model_name="comment",
            name="media",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="comments",
                to="files.media",
            ),
        ),
        migrations.AddField(
            model_name="comment",
            name="parent",
            field=mptt.fields.TreeForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="children",
                to="files.comment",
            ),
        ),
        migrations.AddField(
            model_name="comment",
            name="user",
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name="category",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddIndex(
            model_name="rating",
            index=models.Index(fields=["user", "media"], name="files_ratin_user_id_72ca6a_idx"),
        ),
        migrations.AlterUniqueTogether(
            name="rating",
            unique_together={("user", "media", "rating_category")},
        ),
        migrations.AddIndex(
            model_name="media",
            index=django.contrib.postgres.indexes.GinIndex(fields=["search"], name="files_media_search_7194c6_gin"),
        ),
    ]
